function md=icetransient_wrapper(md);
%ICETRANSIENT_WRAPPER - wrapper of the transient solution sequence
%
%   wrapper for transient solution
%   we need a wrapper so that we can launch the transient solution using Matlab parallel, 
%
%   Usage:
%      md=icetransient_wrapper(md)

%start timing
t1=clock;

%If running in parallel, launch core transient routine within a parallel job.
if strcmpi(md.cluster,'yes'),
	sched = findResource('scheduler', 'configuration', md.scheduler_configuration);
	pjob = createParallelJob(sched);
	set(pjob, 'FileDependencies', {'icetransient.m'});
	set(pjob, 'MaximumNumberOfWorkers', md.np); set(pjob, 'MinimumNumberOfWorkers', md.np);
	t = createTask(pjob, @icetransient, 1, {md});
	set(t, 'CaptureCommandWindowOutput', true)
	disp('   Submitting job to cluster');
	submit(pjob);
	waitForState(pjob);
	get(t, 'CommandWindowOutput')
	get(t,'ErrorMessage')
	disp('   Done running on cluster');
else
	md=icetransient(md);
end

%stop timing
t2=clock;

disp(sprintf('\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']));
