function md=icethermal_wrapper(md,analysis_type);
%ICETHERMAL_WRAPPER - wrapper of the thermal solution
%
%   thermal wrapper for thermal matlab driven solution. 
%   we need a wrapper so that we can launch the thermal solution using Matlab parallel, 
%
%   Usage:
%      md=icethermal_wrapper(md,analysis_type);

%start timing
t1=clock;

%If running in parallel, launch core thermal routine within a parallel job.
if strcmpi(md.cluster,'yes'),
	sched = findResource('scheduler', 'configuration', md.scheduler_configuration);
	pjob = createParallelJob(sched);
	set(pjob, 'FileDependencies', {'icethermal.m'});
	set(pjob, 'MaximumNumberOfWorkers', md.np); set(pjob, 'MinimumNumberOfWorkers', md.np);
	t = createTask(pjob, @icethermal, 1, {md});
	set(t, 'CaptureCommandWindowOutput', true)
	disp('   Submitting job to cluster');
	submit(pjob);
	waitForState(pjob);
	get(t, 'CommandWindowOutput')
	get(t,'ErrorMessage')
	disp('   Done running on cluster');
else
	md=icethermal(md,analysis_type);
end

%stop timing
t2=clock;

disp(sprintf('\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']));
