function md=iceparameters_wrapper(md);
%ICEPARAMETERS_WRAPPER - wrapper of the parameters solution sequence
%
%   parameters wrapper for parameters matlab driven solution. 
%   we need a wrapper so that we can launch the parameters solution using Matlab parallel, 
%
%   Usage:
%      md=iceparameters_wrapper(md)

%start timing
t1=clock;

%If running in parallel, launch core parameters routine within a parallel job.
if strcmpi(md.cluster,'yes'),
	sched = findResource('scheduler', 'configuration', md.scheduler_configuration);
	pjob = createParallelJob(sched);
	set(pjob, 'FileDependencies', {'iceparameters.m'});
	set(pjob, 'MaximumNumberOfWorkers', md.np); set(pjob, 'MinimumNumberOfWorkers', md.np);
	t = createTask(pjob, @iceparameters, 1, {md});
	set(t, 'CaptureCommandWindowOutput', true)
	disp('   Submitting job to cluster');
	submit(pjob);
	waitForState(pjob);
	get(t, 'CommandWindowOutput')
	get(t,'ErrorMessage')
	disp('   Done running on cluster');
else
	md=iceparameters(md);
end

%stop timing
t2=clock;

disp(sprintf('\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']));
