function md=icediagnostic_wrapper(md);
%ICEDIAGNOSTIC_WRAPPER - wrapper of diagnostic solution
%
%   diagnostic wrapper for diagnostic matlab driven solution. 
%   we need a wrapper so that we can launch the diagnostic solution using Matlab parallel, 
%
%   Usage:
%      md=icediagnostic_wrapper(md)
%
%   See also: ICEDIAGNOSTIC, ICEDIAGNOSTIC2D, ICEDIAGNOSTIC3D, ICEDIAGNOSTIC_CORE_NONLINEAR ICEDIAGNOSTIC_CORE_LINEAR

%start timing
t1=clock;

%If running in parallel, launch core diagnostic routine within a parallel job.
if strcmpi(md.cluster,'yes'),
	sched = findResource('scheduler', 'configuration', md.scheduler_configuration);
	pjob = createParallelJob(sched);
	set(pjob, 'FileDependencies', {'icediagnostic.m'});
	set(pjob, 'MaximumNumberOfWorkers', md.np); set(pjob, 'MinimumNumberOfWorkers', md.np);
	t = createTask(pjob, @icediagnostic, 1, {md});
	set(t, 'CaptureCommandWindowOutput', true)
	disp('   Submitting job to cluster');
	submit(pjob);
	waitForState(pjob);
	get(t, 'CommandWindowOutput')
	get(t,'ErrorMessage')
	disp('   Done running on cluster');
else
	md=icediagnostic(md);
end

%stop timing
t2=clock;

disp(sprintf('\n%s\n',['solution converged in ' num2str(etime(t2,t1)) ' seconds']));
