function strainrate=StrainRateCompute(m,inputs,type);
%STRAINRATECOMPUTE - compute the strain rate
%
%   return a vector of size (numberofelements,1), holding the strain rate for 
%   every element
%
%   Usage:
%      strainrate=StrainRateCompute(m,inputs,type)

%global variables
global cluster gridset

%recover fem model fields
elements=m.elements;
grids=m.grids;
materials=m.materials;
loads=m.loads;
gridset=m.gridset;

%figure out active elements that will take part in the stiffness and load generation
[n1,n2]=GetNumberOfActiveElements(elements);

if strcmpi(type,'2d')
	%initialize vectors
	strainrate=struct('xx',[],'yy',[],'xy',[],'principalvalue1',[],'principalaxis1',[],'principalvalue2',[],'principalaxis2',[]);
	strainrate1=zeros((n2-n1)+1,3);
	A1=zeros((n2-n1)+1,1); Vx1=zeros((n2-n1)+1,1); Vy1=zeros((n2-n1)+1,1);
	A2=zeros((n2-n1)+1,1); Vx2=zeros((n2-n1)+1,1); Vy2=zeros((n2-n1)+1,1);

	%Go through all elements and call the strainrate routine, then compute eigen values and vector
	for n=n1:n2,
		if ~isempty(elements(n).element),
			strainratevector=StrainRate(elements(n).element,grids,materials,inputs)';

			strainratematrix=[strainratevector(1) strainratevector(3) 
				      strainratevector(3)  strainratevector(2)];

			%eigen values and vectors
			[directions,value]=eig(strainratematrix);

			%Plug into global vectors
			strainrate1(n,:)=strainratevector;
                        A1(n,1)=value(1,1); A2(n,1)=value(2,2);
                        Vx1(n,1)=directions(1,1); Vx2(n,1)=directions(1,2);
                        Vy1(n,1)=directions(2,1); Vy2(n,1)=directions(2,2);
		end
	end

	%plug results into outputs
	%NB: Matlab sorts the eigen value in increasing order, we want the reverse
	%Components
	strainrate.xx=strainrate1(:,1)*(365.25*24*3600);  %strain rate in 1/a instead of 1/s
	strainrate.yy=strainrate1(:,2)*(365.25*24*3600);
	strainrate.xy=strainrate1(:,3)*(365.25*24*3600);
	%principal axis and values
	strainrate.principalvalue2=A1;
	strainrate.principalaxis2=[Vx1 Vy1];
	strainrate.principalvalue1=A2;
	strainrate.principalaxis1=[Vx2 Vy2];
	%Norm or effective value
	straintare.effectivevalue=1/sqrt(2)*sqrt(strainrate.xx.^2+strainrate.yy.^2+2*strainrate.xy.^2);
else
	%initialize vectors
	strainrate=struct('xx',[],'yy',[],'zz',[],'xy',[],'xz',[],'yz',[],'principalvalue1',[],'principalaxis1',[],'principalvalue2',[],'principalaxis2',[],'principalvalue3',[],'principalaxis3',[]);
	strainrate1=zeros((n2-n1)+1,6);
	A1=zeros((n2-n1)+1,1); Vx1=zeros((n2-n1)+1,1); Vy1=zeros((n2-n1)+1,1); Vz1=zeros((n2-n1)+1,1);
	A2=zeros((n2-n1)+1,1); Vx2=zeros((n2-n1)+1,1); Vy2=zeros((n2-n1)+1,1); Vz2=zeros((n2-n1)+1,1);
	A3=zeros((n2-n1)+1,1); Vx3=zeros((n2-n1)+1,1); Vy3=zeros((n2-n1)+1,1); Vz3=zeros((n2-n1)+1,1);

	%Go through all elements and call the strainrate routine, then compute eigen values and vector
	for n=n1:n2,
		if ~isempty(elements(n).element),
			strainratevector=StrainRate(elements(n).element,grids,materials,inputs)';

			strainratematrix=[strainratevector(1) strainratevector(4) strainratevector(5)
				      strainratevector(4)  strainratevector(2)  strainratevector(6)
				      strainratevector(5)  strainratevector(6)  strainratevector(3)];

			%eigen values and vectors
			[directions,value]=eig(strainratematrix);

                        %Plug into global vectors
			strainrate1(n,:)=strainratevector;
                        A1(n,1)=value(1,1); A2(n,1)=value(2,2); A3(n,1)=value(3,3);
                        Vx1(n,1)=directions(1,1); Vx2(n,1)=directions(1,2); Vx3(n,1)=directions(1,3);
                        Vy1(n,1)=directions(2,1); Vy2(n,1)=directions(2,2); Vy3(n,1)=directions(2,3);
                        Vz1(n,1)=directions(3,1); Vz2(n,1)=directions(3,2); Vz3(n,1)=directions(3,3);
		end
	end

	%plug results into outputs
	%NB: Matlab sorts the eigen value in increasing order, we want the reverse
	%Components
	strainrate.xx=strainrate1(:,1)*(365.25*24*3600);  %strain rate in 1/a instead of 1/s
	strainrate.yy=strainrate1(:,2)*(365.25*24*3600);
	strainrate.zz=strainrate1(:,3)*(365.25*24*3600);
	strainrate.xy=strainrate1(:,4)*(365.25*24*3600);
	strainrate.xz=strainrate1(:,5)*(365.25*24*3600);
	strainrate.yz=strainrate1(:,6)*(365.25*24*3600);
	%principal axis and values
	strainrate.principalvalue3=A1;
	strainrate.principalaxis3=[Vx1 Vy1 Vz1];
	strainrate.principalvalue2=A2;
	strainrate.principalaxis2=[Vx2 Vy2 Vz2];
	strainrate.principalvalue1=A3;
	strainrate.principalaxis1=[Vx3 Vy3 Vz3];
	%Norm or effective value
	straintare.effectivevalue=1/sqrt(2)*sqrt(strainrate.xx.^2+strainrate.yy.^2+strainrate.zz.^2+2*strainrate.xy.^2+2*strainrate.xz.^2+2*strainrate.yz.^2);
end
