function [part tpart]=PartitioningVector(md,grids);
%PARTITIONINGVECTOR - build the partitioning vector
%
%   Return a partitioning vector, and its transpose. The partitioning vector
%   part shows how each dof is distributed. tpart allows from a partitioned dof to go back
%   to its original position on the grid list.
%
%   Usage:
%      [part tpart]=PartitioningVector(md,grids)

global cluster

if ~cluster,
    part=1:1:md.numberofgrids;
    tpart=1:1:md.numberofgrids;
else
    part=zeros(md.numberofgrids,1);
    %First deal with non border grids.

    %How many grids for each lab?
    count=0;
    for i=1:md.numberofgrids,
        if ((~isempty(grids(i).grid)) & (grids(i).grid.border==0)),
            count=count+1;
        end
    end

    %broacast
	labcounts=gcat(count);

	%create offset into partition vector
	offset=0;
	for i=1:(labindex-1),
		offset=offset+labcounts(i);
	end

	%create partition vector
	for i=1:md.numberofgrids,
		if ((~isempty(grids(i).grid)) & (grids(i).grid.border==0)),
			offset=offset+1;
			part(offset)=i;
		end
	end

	part=gplus(part);

	%deal with border grids
	count=gplus(count);
	for i=1:md.numberofgrids,
		if ((~isempty(grids(i).grid)) & (grids(i).grid.border==1)),
			count=count+1;
			part(count)=i;
		end
	end

	%Build tpart:
	tpart=zeros(md.numberofgrids,1);
	for i=1:md.numberofgrids,
		tpart(part(i))=i;
	end
end

end %end function
