function [elements,grids,loads,constraints,materials,part,tpart]=ModelProcessor(md,solutiontype),
%MODELPROCESSOR - process model for a given solution sequence
%
%   This routine uses all the informations in the model md and put them
%   into different structures (grids, elements, loads, constrained,materials)
%   that will be used to create the stiffness matrix and load vector.
%   After this routine, the model md should not be called until the end of the
%   solution sequence.
%
%   Usage:
%      [elements,grids,loads,constraints,materials,part,tpart]=ModelProcessor(md,solutiontype)

global cluster
if strcmpi(solutiontype,'diagnostic_horiz'),
	[elements,grids,loads,constraints,materials,part,tpart]=ModelProcessorDiagnosticHoriz(md);
elseif strcmpi(solutiontype,'diagnostic_vert'),
	[elements,grids,loads,constraints,materials,part,tpart]=ModelProcessorDiagnosticVert(md);
elseif strcmpi(solutiontype,'diagnostic_hutter'),
	[elements,grids,loads,constraints,materials,part,tpart]=ModelProcessorDiagnosticHutter(md);
elseif strcmpi(solutiontype,'diagnostic_basevert'),
	[elements,grids,loads,constraints,materials,part,tpart]=ModelProcessorDiagnosticBaseVert(md);
elseif strcmpi(solutiontype,'thermalsteady')| strcmpi(solutiontype,'thermaltransient'),
	[elements,grids,loads,constraints,materials,part,tpart]=ModelProcessorThermal(md,solutiontype);
elseif strcmpi(solutiontype,'meltingsteady')| strcmpi(solutiontype,'meltingtransient'),
	[elements,grids,loads,constraints,materials,part,tpart]=ModelProcessorMelting(md,solutiontype);
elseif strcmpi(solutiontype,'prognostic'),
	[elements,grids,loads,constraints,materials,part,tpart]=ModelProcessorPrognostic(md);
elseif strcmpi(solutiontype,'diagnostic_stokes'),
	[elements,grids,loads,constraints,materials,part,tpart]=ModelProcessorDiagnosticStokes(md);
elseif strcmpi(solutiontype,'bed_slope_compute') | strcmpi(solutiontype, 'surface_slope_compute'),
	[elements,grids,loads,constraints,materials,part,tpart]=ModelProcessorSlopeCompute(md,solutiontype);

else 
	error('ModelProcessor error message: solution type not supported yet');
end
