function [Kff Kfs]=IceReducematrixfromgtof(Kgg,Gmn)
%ICEREDUCEMATRIXFROMGTOF - reduce stiffness matrix from gset to fset
%
%   Usage:
%      [Kff Kfs]=IceReducematrixfromgtof(Kgg,Gmn)

global gridset

%Reduce matrix from g-size to n-size
Knn= IceReducematrix( Kgg, Gmn, gridset.pv_m, gridset.pv_n, gridset.msize, 2 );

%Reduce matrix from n-size to f-size

if  gridset.ssize>0  
	Kff= Knn(gridset.pv_f, gridset.pv_f);
	Kfs= Knn(gridset.pv_f,gridset.pv_s);
else
	Kff= Knn;
	Kfs=[];
end
