function u_g=CieloVelocityExtrude(md,u_g);
%Extrude collapsed horizontal velocities present in MacAyeal elements

if strcmpi(md.type,'2d'),
	%do nothing, we don't have a 3d mesh anyway.
else

	%Find list of 2d grids that belong to the collapsed macayeal elements.
	%Numbering for these 2d grids corresponds to the initial 2d mesh.
	grids2d=md.proj2d_coll_grids(1:md.number_grids2d_coll);
	vx2d=u_g(1:6:6*md.number_grids2d_coll);
	vy2d=u_g(2:6:6*md.number_grids2d_coll);

	%Plug values for these 2d grids into the 2d mesh: 
	vx=zeros(md.numberofgrids2d,1);
	vx(grids2d)=vx2d;

	vy=zeros(md.numberofgrids2d,1);
	vy(grids2d)=vy2d;

	%Extrude across the 3d mesh
	vx3d=project3d(md,vx,'node');
	vx3d(1:md.number_grids2d_coll)=0;
	vy3d=project3d(md,vy,'node');
	vy3d(1:md.number_grids2d_coll)=0;

	%For border grids between MacAyeal and Pattyn, values will double, fix that.
	for i=1:length(md.penalties), 
		vx3d(md.penalties(i).grids3d_noncollapsed)=0;
		vy3d(md.penalties(i).grids3d_noncollapsed)=0;
	end

	%Plug back into u_g
	u_g(1:6:end)=u_g(1:6:end)+vx3d;
	u_g(2:6:end)=u_g(2:6:end)+vy3d;

end

end %end function
