function X=Solver(A,B,solver_type);
%ICESOLVER - solve the matrix equation AX=B
%
%   Solver AX=B, with Chol, Lu or general solvers from matlab.
%   We can use either the LU or the Cholesky decomposition, but the
%   Cholesky decomposition is twice as efficient as LU for symmetric
%   definite positive matrix
%
%   Usage:
%      X=IceSolver(A,B,solver_type);

if strcmpi(solver_type,'lu'),
	% Solve by LU decomposition. 
	[L,U] = lu(A);
	X = U\(L\B);
elseif strcmpi(solver_type,'cholesky'),
	% Solve by Choleski decomposition.
	L = chol(A); X = L\(L'\B);
else
	% use matlab's generic solver
	X = A\B;
end
