function [sx,sy,sxy,s]=shear2d(md)
%SHEAR2D - computes 2d strain rate
%
%   This routine computes the strain rate of 2d models
%
%   Usage:
%      [sx,sy,sxy,s]=shear2d(md);

alpha=zeros(md.numberofelements,3); beta=zeros(md.numberofelements,3); 
gamma=zeros(md.numberofelements,3); area=zeros(md.numberofelements,1);

for n=1:md.numberofelements
	X=inv([md.x(md.elements(n,:)) md.y(md.elements(n,:)) ones(3,1)]);
	alpha(n,:)=X(1,:);
	beta(n,:)=X(2,:);
end
clear X;


summation=[1;1;1];
sx=(md.vx(md.elements).*alpha)*summation;
uy=(md.vx(md.elements).*beta)*summation;
vx=(md.vy(md.elements).*alpha)*summation;
sy=(md.vy(md.elements).*beta)*summation;						
sxy=(uy+vx)/2;
s=sqrt(sx.^2+sy.^2+sxy.^2+sx.*sy);
