function plotoptions=recover_plot_options(md,varargin,numberofplots);
%RECOVER_PLOT_OPTIONS - recover plot options
%
%   Usage:
%      plotoptions=recover_plot_options(md,varargin,numberofplots);
%
%   See also: PARSE_OPTIONS, PLOTMODEL

%initialize options string.
plotoptions=cell(numberofplots,1);

%initialize options.
options=cell(0,2);

for i=1:size(plotoptions,1),
	plotoptions{i}=options;
end

%make sure length(varargin) is even
if mod(length(varargin),2),
	error('recover_plot_options error message: an even number of options is necessary');
end

%go through varargin, extract options and plug them into subplot options, by order of appearance
for i=1:length(varargin)/2,

	optionstring=varargin{2*i-1};
	optionvalue=varargin{2*i};

	if length(optionstring)>4 & strcmpi(optionstring(end-3:end),'#all'),
		optionstring=optionstring(1:end-4);
		for j=1:size(plotoptions,1), 
			ispresent=0;
			options_j=plotoptions{j};
			for k=1:size(options_j,1),
				if strcmpi(options_j{k,1},optionstring),
					options_j{k,2}=optionvalue;
					ispresent=1;
				end
			end
			plotoptions{j}=options_j;

			if ~ispresent,
				options_j{end+1,1}=optionstring;
				options_j{end,2}=optionvalue;
				plotoptions{j}=options_j;
			end
		end
	else
		
		%look for an a pound sign that would enforce choice of plot number
		if length(optionstring)>2 & strcmpi(optionstring(end-1),'#'),
			optionstring(end-1);
			plotnum=str2num(optionstring(end));
			options_j=plotoptions{plotnum};
			options_j{end+1,1}=optionstring(1:end-2);
			options_j{end,2}=optionvalue;
			plotoptions{plotnum}=options_j;
		else
			for j=1:numberofplots,
				options_j=plotoptions{j};

				alreadypresent=0;
				for k=1:size(options_j,1),
					if strcmpi(optionstring,options_j{k,1}),
						alreadypresent=1;
						break;
					else
						alreadypresent=0;
					end
				end
				if alreadypresent,
					continue;
				else
					options_j{end+1,1}=optionstring;
					options_j{end,2}=optionvalue;
					plotoptions{j}=options_j;
					break;
				end
			end
		end
	end
end

for i=1:length(plotoptions),
	options_i=plotoptions{i};
	new_options_i=cell(1,size(options_i,1)*size(options_i,2));
	counter=1;
	for j=1:size(options_i,1),
		new_options_i{counter}=options_i{j,1};
		new_options_i{counter+1}=options_i{j,2};
		counter=counter+2;
	end
	plotoptions{i}=new_options_i;
end

%%DEBUG
%for i=1:length(plotoptions),
%	disp(['Options ' num2str(i)]);
%	plotoptions{i}
%end
%error('debug')
