function plot_tensor(md,options_structure,width,i,type);
%PLOT_TENSOR - plot tensor components
%
%   Usage:
%      plot_tensor(md,options_structure,width,i);
%
%   See also: PLOTMODEL

h=subplot(width,width,i); axis off; pos=get(h,'Position');

plot_options.offsetx=pos(1);
plot_options.offsety=pos(2);
plot_options.width=pos(3);
plot_options.height=pos(4);

%Figure out tensor type:
if strcmpi(type(1:6),'strain'),
	tensor=md.strainrate;
elseif strcmpi(type(1:6),'stress'),
	tensor=md.stress;
elseif strcmpi(type(1:16),'deviatoricstress'),
	tensor=md.deviatoricstress;
else
	error('plot_tensor error message: unsupported type of tensor');
end

%Figure out type of plot being requested
if strcmpi(type(end-5:end),'tensor') | strcmpi(type,'strainrate') | strcmpi(type,'deviatoricstress') | strcmpi(type,'stress'),
	plot_tensor_components(md,options_structure,width,i,tensor,type,plot_options);
	return;
elseif strcmpi(type(end-8:end),'principal'),
	plot_tensor_principal(md,options_structure,width,i,tensor,type,plot_options);
	return;
elseif strcmpi(type(end-13:end-1),'principalaxis'),
	plot_tensor_principalaxis(md,options_structure,width,i,tensor,type,plot_options);
	return;
else
	error('plot_tensor error message: unsurported type of plot');
end
