function plot_segmentnumbering(md,options_structure,width,i);
%PLOT_SEGMENTNUMBERING - plot segment numbering
%
%   Usage:
%      plot_segmentnumbering(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%plot mesh boundaries
subplot(width,width,i); 

%process data and model
[x y z segments is2d]=processmesh(md,options_structure);

error('not implemented yet');
%plot
if is2d
	%plot mesh 
	A=segments(:,1); B=segments(:,2); C=segments(:,3);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	for i=1:size(segments,1),
		text(sum(x(segments(i,:)))/3,sum(y(segments(i,:)))/3,sum(z(segments(i,:)))/3,num2str(segmentnumbers(i)));
		if ~isnan(options_structure.highlight) & ismember(segmentnumbers(i),options_structure.highlight)
			A=segments(i,1); B=segments(i,2);  C=segments(i,3);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
		end
	end
else
	%plot mesh 
	A=segments(:,1); B=segments(:,2); C=segments(:,3); D=segments(:,4); E=segments(:,5); F=segments(:,6);
	patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [1 1 1],'FaceColor','none','EdgeColor','black');
	for i=1:size(segments,1),
		text(sum(x(segments(i,:)))/6,sum(y(segments(i,:)))/6,sum(z(segments(i,:)))/6,num2str(segmentnumbers(i)));
		if ~isnan(options_structure.highlight) & ismember(segmentnumbers(i),options_structure.highlight)
			A=segments(i,1); B=segments(i,2);  C=segments(i,3);  D=segments(i,4); E=segments(i,5);  F=segments(i,6);
			patch( 'Faces', [A B C], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [D E F], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [A B E D], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [B E F C ], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
			patch( 'Faces', [C A D F ], 'Vertices', [x y z],'FaceVertexCData', [0.9 0.5 0.5],'FaceColor','flat','EdgeColor','black');
		end
	end
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Element numbering';
end
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(options_structure);
