function plot_riftvel(md,options_structure,width,i);
%PLOT_RIFTVEL - plot rift velocity
%
%   Usage:
%      plot_riftvel(md,options_structure,width,i);
%
%   See also: PLOTMODEL

%plot mesh boundaries
subplot(width,width,i); 

%units
if ~isnan(options_structure.unitmultiplier),
	md.x=md.x*options_structure.unitmultiplier;
	md.y=md.y*options_structure.unitmultiplier;
	md.z=md.z*options_structure.unitmultiplier;
end

for i=1:size(md.segments,1),
	plot(md.x(md.segments(i,1:2)),md.y(md.segments(i,1:2)),'k.-');hold on;
end

%plot rift velocities
hold on;

isp1=0;
isp2=0;

if isstruct(md.rifts),
	%plot mesh boundaries
	for i=1:size(md.segments,1),
		h1=plot(md.x(md.segments(i,1:2)),md.y(md.segments(i,1:2)),'b-');
	end
	for i=1:size(md.rifts,1),
		penaltypairs=md.rifts(i).penaltypairs;

		segments=md.rifts(i).segments;
		for j=1:size(segments,1),
			plot(md.x(segments(j,1:2)),md.y(segments(j,1:2)),'b-');
		end

		normal=zeros(2,1);
		for j=1:size(penaltypairs,1),
			normal(1)=penaltypairs(j,5);
			normal(2)=penaltypairs(j,6);

			vx1=md.vx(penaltypairs(j,1)); vx2=md.vx(penaltypairs(j,2)); vy1=md.vy(penaltypairs(j,1)); vy2=md.vy(penaltypairs(j,2));
			penetration=(vx2-vx1)*normal(1)+(vy2-vy1)*normal(2);
			%if penetration is negative, plot in black, positive, plot in red;: ie: if rift is closing, black, if rift is opening, red.
			if(penetration>0),
				p2=plot(md.x(penaltypairs(j,1)) ,md.y(penaltypairs(j,1)),'r*');
				isp2=1;
			else
				p1=plot(md.x(penaltypairs(j,1)) ,md.y(penaltypairs(j,1)),'k*');
				isp1=1;
			end
		end

		%point out the tips
		h2=plot(md.x(md.rifts(i).tips(1)),md.y(md.rifts(i).tips(1)),'g*');
		plot(md.x(md.rifts(i).tips(2)),md.y(md.rifts(i).tips(2)),'g*');
		segments=md.rifts(i).segments(:,1:2);
		h3=quiver(md.x(segments),md.y(segments),md.vx(segments),md.vy(segments));
		set(h3,'Color',[1 0 0]);
	end
	if isp1 & isp2
		legend([h1,h2,p1,p2,h3],'mesh boundaries','rift tips',' rifts closing','rifts opening','velocities')
	elseif isp1
		legend([h1,h2,p1,h3],'mesh boundaries','rift tips',' rifts closing','velocities')
	elseif isp2
		legend([h1,h2,p2,h3],'mesh boundaries','rift tips','rifts opening','velocities')
	else
		legend([h1,h2,h3],'mesh boundaries','rift tips','velocities')
	end
else
	error('plot error message: no rifts available!');
end

%apply options
if isnan(options_structure.title)
	options_structure.title='Rift Velocities';
end 
if isnan(options_structure.colorbar)
	options_structure.colorbar=0;
end
applyoptions(md,[],options_structure);
