function export_results=export(md,results, xlower,ylower,xposting,yposting,xsize,ysize)
%EXPORT - exports results from a mesh to a regular grid
%
%   this routine exports results from a mesh to a regular grid 
%   of postings (xposting,yposint) with coordinates for lower left 
%   corner (xlower,ylower), and of size (xsize,ysize) 
%
%   Usage:
%      export_results=export(md,results, xlower,ylower,xposting,yposting,xsize,ysize)

%Build x_m and y_m
x_m=(xlower):xposting:(xlower+xposting*(xsize-1));
y_m=(ylower):yposting:(ylower+yposting*(ysize-1));

[X,Y]=meshgrid(x_m,y_m);
export_results=griddata(md.x,md.y,results,X,Y);
