function displayresults(md)
%DISPLAYRESULTS - display results
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays results from model md, 
%   only if requested.
%
%   Usage:
%      displayresults(md)

disp(sprintf('   Results:'));
disp(sprintf('      ''%s''','diagnostic'));
if isempty(md.vx), disp(sprintf('         vx: N/A')); else disp(sprintf('         vx [m/a]: (%i)',length(md.vx))); end
if isempty(md.vy), disp(sprintf('         vy: N/A')); else disp(sprintf('         vy [m/a]: (%i)',length(md.vy))); end
if isempty(md.vz), disp(sprintf('         vz: N/A')); else disp(sprintf('         vz [m/a]: (%i)',length(md.vz))); end
if isempty(md.vel), disp(sprintf('         vel: N/A')); else disp(sprintf('         vel [m/a]: (%i)',length(md.vel))); end
if isempty(md.pressure), disp(sprintf('         pressure: N/A')); else disp(sprintf('         pressure [Pa]: (%i)',length(md.pressure))); end
if isempty(md.viscousheating), disp(sprintf('         viscousheating: N/A')); else disp(sprintf('         viscousheating [Pa]: (%i)',length(md.viscousheating))); end
if ~isstruct(md.stress), disp(sprintf('         stress: N/A')); 
else 
	disp(sprintf('         stress [Pa]:'))
	struct_display(md.stress,'         ');
end
if ~isstruct(md.deviatoricstress), disp(sprintf('         deviatoricstress: N/A')); 
else 
	disp(sprintf('         deviatoricstress [Pa]:'))
	struct_display(md.deviatoricstress,'         ');
end
if ~isstruct(md.strainrate), disp(sprintf('         strainrate: N/A')); 
else 
        disp(sprintf('         strainrate [1/a]:'))
        struct_display(md.strainrate,'         ');
end

disp(sprintf('      ''%s''','transient'));
if ~isstruct(md.transient_results), disp(sprintf('         transient_results: N/A')); 
else 
	struct_display(md.transient_results,'         ');
end

disp(sprintf('      ''%s''','control method'));
if isempty(md.cont_vx), disp(sprintf('         cont_vx: N/A')); else disp(sprintf('         cont_vx [m/a]: (%i)',length(md.cont_vx))); end
if isempty(md.cont_vy), disp(sprintf('         cont_vy: N/A')); else disp(sprintf('         cont_vy [m/a]: (%i)',length(md.cont_vy))); end
if isempty(md.cont_vz), disp(sprintf('         cont_vz: N/A')); else disp(sprintf('         cont_vz [m/a]: (%i)',length(md.cont_vz))); end
if isempty(md.cont_vel), disp(sprintf('         cont_vel: N/A')); else disp(sprintf('         cont_vel [m/a]: (%i)',length(md.cont_vel))); end
if isempty(md.cont_parameters), disp(sprintf('         cont_parameters: N/A')); else disp(sprintf('         cont_parameters: (%i)',length(md.cont_parameters))); end
if isempty(md.cont_J), disp(sprintf('         cont_J: N/A')); else disp(sprintf('         cont_J: (%i)',length(md.cont_J))); end

	
disp(sprintf('      ''%s''','thermal'));
if isempty(md.temperature), disp(sprintf('         temperature: N/A')); else disp(sprintf('         temperature [K]: (%i)',length(md.temperature))); end
if ~isstruct(md.thermaltransient_results), disp(sprintf('         thermaltransient_results: N/A')); 
else 
	struct_display(md.thermaltransient_results,'         ');
end

disp(sprintf('      ''%s''','mesh2grid'));
if isempty(md.mesh2grid_results) | isnan(md.mesh2grid_results), disp(sprintf('         mesh2grid_results: N/A')); else disp(sprintf('         mesh2grid_results: (%i)',length(md.mesh2grid_results))); end

end

function struct_display(structure,offset)
structure_fields=fields(structure);
for i=1:length(structure_fields),
	disp(sprintf('%s',[offset '   ' structure_fields{i} ': (' num2str(size( eval([' structure.' structure_fields{i}]),1))  ')' ]));
end

end
