function displaymesh(md)
%DISPLAYMESH - display mesh information
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays mesh information from model md, 
%   only if requested.
%
%   Usage:
%      displaymesh(md)

disp(sprintf('   Mesh:')); 
disp(sprintf('      type: %s',md.type));

if strcmpi(md.type,'2d'),
	disp(sprintf('      numberofelements: %i',md.numberofelements));
	disp(sprintf('      numberofgrids: %i',md.numberofgrids)); 
	if ~isnan(md.dof),
		disp(sprintf('      number of dofs: %i',md.dof)); 
	end
	disp(sprintf('      elements: (%i-%i) (index into (x,y,z), coordinates of the grids)',md.numberofelements,size(md.elements,2))); 
	disp(sprintf('      elements_type: (%i) (type of elements, according to number of grids per element)',md.numberofelements));
	disp(sprintf('      x: (%i) (grid x coordinates)',md.numberofgrids));
	disp(sprintf('      y: (%i) (grid y coordinates)',md.numberofgrids));
	disp(sprintf('      z: (%i) (grid z coordinates)',md.numberofgrids));
elseif strcmpi(md.type,'3d'),

	disp(sprintf('      Original 2d mesh:'));
	disp(sprintf('         numberofelements2d: %i',md.numberofelements2d));
	disp(sprintf('         numberofgrids2d: %i',md.numberofgrids2d)); 
	disp(sprintf('         elements2d: (%i-%i) (index into (x,y,z), coordinates of the grids)',md.numberofelements2d,size(md.elements2d,2))); 
	disp(sprintf('         elements_type2d: (%i) (element types, according to number of grids)',md.numberofelements2d));
	disp(sprintf('         x2d: (%i) (grid x coordinates)',md.numberofgrids2d));
	disp(sprintf('         y2d: (%i) (grid y coordinates)',md.numberofgrids2d));
	disp(sprintf('         z2d: (%i) (grid z coordinates)',md.numberofgrids2d));

	disp(sprintf('      Extruded 3d mesh: '));
	disp(sprintf('         numberofelements: %i',md.numberofelements));
	disp(sprintf('         numberofgrids: %i',md.numberofgrids)); 
	if ~isnan(md.dof),
		disp(sprintf('      number of dofs: %i',md.dof)); 
	end
	disp(sprintf('         elements: (%i-%i) (index into (x,y,z), coordinates of the grids)',md.numberofelements,size(md.elements,2))); 
	disp(sprintf('         elements_type: (%i) (element types, according to number of grids)',md.numberofelements));
	disp(sprintf('         x: (%i) (grid x coordinates)',md.numberofgrids));
	disp(sprintf('         y: (%i) (grid y coordinates)',md.numberofgrids));
	disp(sprintf('         z: (%i) (grid z coordinates)',md.numberofgrids));
	disp(sprintf('         numlayers: (%i) (number of extrusion layers)',md.numlayers));
	disp(sprintf('         gridoncollapsed: (%i)',md.numberofgrids));
	disp(sprintf('         gridonnoncollapsed: (%i)',md.numberofgrids));
	
	disp(sprintf('      Penalties: (%i-%i) (penalties applied to connect 2d and 3d parts of 2d-3d mesh)',size(md.penalties,1),size(md.penalties,2)));
else
	error('only ''2d'' and ''3d'' are allowed for model type');
end


