function displaymaterials(md)
%DISPLAYCONTROL - display material parameters
%
%   To avoid clobbering display.m with every field from model md, 
%   we create this routine that displays material parameters from model md, 
%   only if requested.
%
%   Usage:
%      displaymaterials(md)

disp(sprintf('   Materials:'));
disp(sprintf('      rho_ice: %g [kg/m^3]',md.rho_ice));
disp(sprintf('      rho_water: %g [kg/m^3]',md.rho_water));
if isempty(md.B), disp(sprintf('      B: N/A (flow law parameter)')); else disp(sprintf('      B: (%i) (flow law parameter [Pa/s^(1/n)])',length(md.B))); end
if isempty(md.n), disp(sprintf('      n: N/A (flow law coefficient)')); else disp(sprintf('      n: (%i) (flow law coefficient)',length(md.n))); end
disp(sprintf('      heatcapacity: %g [J/kg/K]',md.heatcapacity));
disp(sprintf('      thermalconductivity: %g [W/m/K]',md.thermalconductivity));
disp(sprintf('      meltingpoint: %g [K] (melting point of ice at 1atm in K)',md.meltingpoint));
disp(sprintf('      latentheat: %g [J/kg] (latent heat of fusion)',md.latentheat));
disp(sprintf('      beta: %g [K/Pa]',md.beta));
disp(sprintf('      mixed_layer_capacity: %g [W/kg/K]',md.mixed_layer_capacity));
disp(sprintf('      thermal_exchange_velocity: %g [m/s]',md.thermal_exchange_velocity));
