function field=ReadData(fid)
%READDATA - ...
%
%   Usage:
%      field=ReadData(fid)


%read field
[type,count]=fread(fid,1,'double');

if count==0,
	field=NaN;
else
	if type==0,
		%string
		stringsize=fread(fid,1,'double');
		field=char(fread(fid,stringsize,'char'));
		field=field(1:end-1)';
	elseif type==1,
		%matrix
		M=fread(fid,1,'double');
		N=fread(fid,1,'double');
		field=fread(fid,[M,N],'double');
	elseif ((type==2) || (type==3)),
		field=fread(fid,1,'double');
	else 
		error('ReadData error message: data type not supported yet!');
	end
end
