function BuildQueueingScriptGeneric(md,solutiontype,executionpath,codepath)
%BUILDQUEUEINGSCRIPTGENERIC - ...
%
%   Usage:
%      BuildQueueingScriptGeneric(md,executionpath,codepath)

%Open queuing script file 
scriptname=[md.name '.queue'];

fid=fopen(scriptname,'w');
if fid==-1,
	error(['BuildQueueingScriptGenericerror message: could not open ' scriptname ' file for ascii writing']);
end

fprintf(fid,'#!/bin/sh\n');
fprintf(fid,'rm -rf %s/%s.lock\n',executionpath,md.name);
fprintf(fid,'mpirun -np %i ',md.np);

if strcmpi(solutiontype,'diagnostic_horiz') |  strcmpi(solutiontype,'diagnostic'),
	fprintf(fid,'%s/diagnostic.exe',codepath);
elseif strcmpi(solutiontype,'control'),
	fprintf(fid,'%s/control.exe',codepath);
elseif strcmpi(solutiontype,'thermalsteady'),
	fprintf(fid,'%s/thermalsteady.exe',codepath);
else
	error('BuildQueueingScriptGeneric error message: unsupported solution type!');
end


fprintf(fid,' %s %s.bin %s.outbin %s.lock 2> %s.errlog >%s.outlog & ',executionpath,md.name,md.name,md.name,md.name,md.name);
fclose(fid);
