function strainrate=StrainRate(triaelem,grids,materials,inputs)
%STRAINRATE - compute the strain rate on each element
%
%  Usage:
%      strainrate=StrainRate(triaelem,grids,materials,inputs)
%
%   See also GETSTRAINRATE, GETVISCOSITY2D

	%initialize
	strainrate=zeros(3,1);
	volume=0;

	%some variables
	NDOF1=1;
	numgrids=3;

	%Get all element grid data:
	xyz_list=getgriddata(triaelem,grids);

	%recover extra inputs
	[velocity_param velocity_is_present]=recover_input(inputs,'velocity');

	%we need velocities to compute thermal profiles (even if it is a zero 
	%vector). 
	if ~velocity_is_present,
		error('StrainRate error message: input velocity not present!');
	end

	%initialize vxvyvz_list
	vxvy_list=zeros(numgrids,2);

	%Build row indices for elementary vector.
	for i=1:numgrids,
		doflist=grids(triaelem.g(i)).grid.doflist;
		for j=1:2,
			dof=doflist(j);
			vxvy_list(i,j)=velocity_param(dof);
		end	
		dof=doflist(1);
	end
	
	% Get gaussian points and weights 
	[num_area_gauss,first_area_gauss_coord,second_area_gauss_coord,third_area_gauss_coord,area_gauss_weights]=GaussTria(2);

	%Start  looping on the number of gaussian points:
	for igarea=1:num_area_gauss,
		%Pick up the gaussian point and its weight:
		gauss_weight=area_gauss_weights(igarea);
		gauss_coord=[first_area_gauss_coord(igarea) second_area_gauss_coord(igarea) third_area_gauss_coord(igarea)];
	    
		%Build Deformational heating
		epsilon=GetStrainRate(triaelem,vxvy_list,xyz_list,gauss_coord);
		viscosity=GetViscosity2d(matice,epsilon); 

		%Get Jacobian determinant:
		Jdet=GetJacobianDeterminant(triaelem,xyz_list,gauss_coord);

		strainrate=strainrate+epsilon*Jdet*gauss_weight;

		volume=volume+Jdet*gauss_weight;
	end %for ig=1:num_area_gauss,

%Divide strainrate, integrated over volume, by volume.
strainrate=strainrate/volume;
