function rgb = rgb(varargin)
%RGB - constructor for rgb object
%
%   Usage:
%      rgb = rgb(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	rgb.type='rgb';
	rgb.grid1=NaN; 
	rgb.grid2=NaN;
	rgb.dof=NaN; 
	rgb=class(rgb,'rgb');
				
case 1
	%If single argument of class rgb, we have a copy constructor. 
	if (isa(varargin{1},'rgb'))
		rgb = varargin{1};
	else
		error('rgb constructor error message: copy constructor called on a non ''rgb'' class object');
	end 
otherwise
	error('rgb constructor error message: 0 of 1 argument only in input.');
end
