function display(pentaelem)
%DISPLAY - displays the fields of a penta element
%
%   echo function for 'pentaelem' class

disp(sprintf('\n%s = \n',inputname(1)));
disp(sprintf('   type: %s',pentaelem.type));
disp(sprintf('   id: %i',pentaelem.id));
disp(sprintf('   material id: %i',pentaelem.matid));
disp(sprintf('   grid ids: %i %i %i %i %i %i',pentaelem.g(1),pentaelem.g(2),pentaelem.g(3),pentaelem.g(4),pentaelem.g(5),pentaelem.g(6)));
disp(sprintf('   thickness: %g %g %g %g %g %g',pentaelem.h(1),pentaelem.h(2),pentaelem.h(3),pentaelem.h(4),pentaelem.h(5),pentaelem.h(6)));
disp(sprintf('   surface: %g %g %g %g %g %g',pentaelem.s(1),pentaelem.s(2),pentaelem.s(3),pentaelem.s(4),pentaelem.s(5),pentaelem.s(6)));
disp(sprintf('   bedrock: %g %g %g %g %g %g',pentaelem.b(1),pentaelem.b(2),pentaelem.b(3),pentaelem.b(4),pentaelem.b(5),pentaelem.b(6)));
disp(sprintf('   friction type: %i',pentaelem.friction_type));
disp(sprintf('   p: %i',pentaelem.p));
disp(sprintf('   q: %i',pentaelem.q));
disp(sprintf('   drag coeff: %g %g %g',pentaelem.k(1),pentaelem.k(2),pentaelem.k(3)));
disp(sprintf('   shelf: %i',pentaelem.shelf));
disp(sprintf('   onbed: %i',pentaelem.onbed));
disp(sprintf('   onsurface: %i',pentaelem.onsurface));
disp(sprintf('   meanvel: %g',pentaelem.meanvel));
disp(sprintf('   epsvel: %g',pentaelem.epsvel));
disp(sprintf('   acceleration (use MacAyeal''s accelerated formulation''): %g',pentaelem.acceleration));
disp(sprintf('   collapse (collapse penta into tria at the base): %g',pentaelem.collapse));
disp(sprintf('   melting: %g %g %g',pentaelem.melting(1),pentaelem.melting(2),pentaelem.melting(3)));
disp(sprintf('   accumulation: %g %g %g',pentaelem.accumulation(1),pentaelem.accumulation(2),pentaelem.accumulation(3)));
disp(sprintf('   geothermalflux: %g %g %g',pentaelem.geothermalflux(1),pentaelem.geothermalflux(2),pentaelem.geothermalflux(3)));
disp(sprintf('   artificial_diffusivity: %s',pentaelem.artificial_diffusivity));
disp(sprintf('   thermal_steadystate: %i',pentaelem.thermal_steadystate));
