function strainrate=StrainRate(pentaelem,grids,materials,inputs)
%STRAINRATE - compute the strain rate on each element
%
%  Usage:
%      strainrate=StrainRate(pentaelem,grids,materials,inputs)
%
%   See also GETSTRAINRATE, GETSTRAINRATESTOKES

	%initialize
	strainrate=zeros(6,1);
	volume=0;

	%some variables
	NDOF1=1;
	numgrids=6;

	%Get all element grid data:
	xyz_list=getgriddata(pentaelem,grids);

	%recover extra inputs
	[velocity_param velocity_is_present]=recover_input(inputs,'velocity');

	%we need velocities to compute thermal profiles (even if it is a zero 
	%vector). 
	if ~velocity_is_present,
		error('StrainRate error message: input velocity not present!');
	end

	%initialize vxvyvz_list
	vxvyvz_list=zeros(numgrids,3);

	%Build row indices for elementary vector.
	for i=1:numgrids,
		doflist=grids(pentaelem.g(i)).grid.doflist;
		for j=1:3,
			dof=doflist(j);
			vxvyvz_list(i,j)=velocity_param(dof);
		end	
		dof=doflist(1);
	end
	
	% Get gaussian points and weights 
	area_order=2;
	num_vert_gauss=2;
	[num_area_gauss,first_area_gauss_coord,second_area_gauss_coord,third_area_gauss_coord,area_gauss_weights, vert_gauss_coord,vert_gauss_weights]=GaussPenta(area_order,num_vert_gauss);

	%Start  looping on the number of gaussian points:
	for igarea=1:num_area_gauss,
		for igvert=1:num_vert_gauss,
			%Pick up the gaussian point and its weight:
			gauss_weight=area_gauss_weights(igarea)*vert_gauss_weights(igvert);
			gauss_coord=[first_area_gauss_coord(igarea) second_area_gauss_coord(igarea) third_area_gauss_coord(igarea) vert_gauss_coord(igvert)];
		    
			%Build strainrate
			strainrate_g=GetStrainRateStokes(pentaelem,vxvyvz_list,xyz_list,gauss_coord);

			%Get Jacobian determinant:
			Jdet=GetJacobianDeterminant(pentaelem,xyz_list,gauss_coord);

			strainrate=strainrate+strainrate_g*Jdet*gauss_weight;
			volume=volume+Jdet*gauss_weight;

		end %for ig=1:vert_gauss,
	end %for ig=1:num_area_gauss,

%Divide strainrate, integrated over volume, by volume.
strainrate=strainrate/volume;
