function pe_reduced=ReduceVectorStokes(pentaelem,Kebubble_temp,pe_temp)
%REDUCEVECTORSTOKES -  compute a reduced vector to get rid of the bubble grid
%
%   This function return the reduced elementary load vector, so that we ca
%   solve the problem without having a grid in the middle of the pentaelem
%            [     ]		            [       ]
%            [     ]	            	[       ]
%   Kebubble=[ Kib ]   and  Pe_temp=[  Pi   ]
%            [     ]	             	[       ]
%            [-----]		            [-------]
%            [ Kbb ]            		[  Pb   ]
%   indice b represents the bubble function (node in the middle of the penta
%   indice i represents the other nodes (the six principal nodes of the penta)
%   So that the elementary reduced load vector is pe_reduced=Pi-Kib*Kbb^-1*Pb
%   See theoryguide for more informations
% 
%   Usage: 
%      pe_reduced=ReduceVectorStokes(pentaelem,Kebubble_temp,pe_temp)
%
%   See also REDUCEMATRIXSTOKES, CREATEPVECTOR

%Create load vector whithout using the bubble function
Kib=Kebubble_temp(1:24,:);
Kbb=Kebubble_temp(25:27,:);

Pi=pe_temp(1:24,:);
Pb=pe_temp(25:27,:);

pe_reduced=Pi-Kib*Kbb^-1*Pb;
