function epsilon=GetStrainRateStokes(pentaelem,vxvyvz_list,xyz_list,gauss_coord)
%GETSTRAINRATESTOKES - return the strain rate for pentaelem with stokes' disgnostic
% 
%   This function return the strain rate needed for Glen's flow law for the element pentaelem
%   The strain rate epsilon is calculated thanks to the formula epsilon=B*U
%   Where epsilon=[exx eyy ezz exy exz eyz] and U=[u1;v1;..;u6;v6]
%   The matrix B is the same as in K=tBDBprime
%
%   Usage:
%      epsilon=GetStrainRateStokes(pentaelem,vxvyvz_list,xyz_list,gauss_coord)
% 
%   See also GETSTRAINRATE, GETBSTOKES

B=GetBStokes(pentaelem,xyz_list,gauss_coord);
B_reduced=B(1:6,[1:3 5:7 9:11 13:15 17:19 21:23]);

vxvyvz_list_transp=vxvyvz_list';
U=[vxvyvz_list_transp(:,1);vxvyvz_list_transp(:,2);vxvyvz_list_transp(:,3);vxvyvz_list_transp(:,4);vxvyvz_list_transp(:,5);vxvyvz_list_transp(:,6)];

epsilon=B_reduced*U; %for the six principal grids
