function dl1dl7=GetNodalFunctionsDerivativesParamsStokes(pentaelem,gauss_coord)
%GETNODALFUNCTIONSDERIVATIVESPARAMSSTOKES - return the values of the nodal functions derivatives on the reference element
%
%   Usage:
%      dl1dl7=GetNodalFunctionsDerivativesParamsStokes(pentaelem,gauss_coord)
%
%   See also GETNODALFUNCTIONSDERIVATIVESPARAMS, GETNODALFUNCTIONSDERIVATIVESBASICSTOKES, GETNODALFUNCTIONSSTOKES

sqrt3=sqrt(3.0);

%Gauss point coordinate in reference element
r=gauss_coord(1,2) - gauss_coord(1,1);
s= - 3.0/sqrt3 *(gauss_coord(1,1)+gauss_coord(1,2) - 2.0/3.0);
zeta=gauss_coord(1,4);

num_grids=7;
dl1dl7=zeros(3,num_grids);

%First nodal function:
dl1dl7(1,1)=-1.0/2.0*(1-zeta)/2;
dl1dl7(2,1)=-sqrt3/6*(1-zeta)/2;
dl1dl7(3,1)=-1.0/2.0*(-1.0/2.0*r-sqrt3/6*s+1/3);

%Second nodal function:
dl1dl7(1,2)=1.0/2.0*(1-zeta)/2;
dl1dl7(2,2)=-sqrt3/6*(1-zeta)/2;
dl1dl7(3,2)=-1.0/2.0*(1.0/2.0*r-sqrt3/6*s+1/3);

%Third nodal function:
dl1dl7(1,3)=0;
dl1dl7(2,3)=sqrt3/3.0*(1-zeta)/2;
dl1dl7(3,3)=-1.0/2.0*(sqrt3/3.0*s+1/3);

%Fourth nodal function:
dl1dl7(1,4)=-1.0/2.0*(1+zeta)/2;
dl1dl7(2,4)=-sqrt3/6*(1+zeta)/2;
dl1dl7(3,4)=1.0/2.0*(-1.0/2.0*r-sqrt3/6*s+1/3);

%Fifth nodal function:
dl1dl7(1,5)=1.0/2.0*(1+zeta)/2;
dl1dl7(2,5)=-sqrt3/6*(1+zeta)/2;
dl1dl7(3,5)=1.0/2.0*(1.0/2.0*r-sqrt3/6*s+1/3);

%Sixth nodal function:
dl1dl7(1,6)=0;
dl1dl7(2,6)=sqrt3/3.0*(1+zeta)/2;
dl1dl7(3,6)=1.0/2.0*(sqrt3/3.0*s+1/3);

%Seventh nodal function:
dl1dl7(1,7)=9.0/2.0*r*(1.0+zeta)*(zeta-1.0)*(sqrt3*s+1.0);
dl1dl7(2,7)=9.0/4.0*(1+zeta)*(1-zeta)*(sqrt3*s^2-2.0*s-sqrt3*r^2);
dl1dl7(3,7)=27*gauss_coord(1,1)*gauss_coord(1,2)*gauss_coord(1,3)*(-2.0*zeta);
