function dh1dh7_basic=GetNodalFunctionsDerivativesBasicStokes(pentaelem,xyz_list,gauss_coord)
%GETNODALFUNCTIONSDERIVATIVESBASICSTOKES - return the values of nodal functions derivatives on the current element
%
%   Usage:
%      dh1dh7_basic=GetNodalFunctionsDerivativesBasicStokes(pentaelem,xyz_list,gauss_coord)
%
%   See also GETNODALFUNCTIONSSTOKES, GETNODALFUNCTIONSDERIVATIVESPARAMSSTOKES, GETNODALFUNCTIONSDERIVATIVESBASIC

num_grids=7;

%Get derivative values with respect to parametric coordinate system:
dh1dh7_param=GetNodalFunctionsDerivativesParamsStokes(pentaelem,gauss_coord); 
	
%Get Jacobian invert: 
Jinv=GetJacobianInvert(pentaelem,xyz_list, gauss_coord);
	
%Build dh1dh7_basic: 
% [dhi/dx]= Jinv'*[dhi/dr]
% [dhi/dy]       [dhi/ds]
% [dhi/dz]       [dhi/dzeta]

dh1dh7_basic=zeros(3,num_grids);	

for i=1:num_grids,
	dh1dh7_basic(1,i)=Jinv(1,1)*dh1dh7_param(1,i)+Jinv(2,1)*dh1dh7_param(2,i)+Jinv(3,1)*dh1dh7_param(3,i);
	dh1dh7_basic(2,i)=Jinv(1,2)*dh1dh7_param(1,i)+Jinv(2,2)*dh1dh7_param(2,i)+Jinv(3,2)*dh1dh7_param(3,i);
	dh1dh7_basic(3,i)=Jinv(1,3)*dh1dh7_param(1,i)+Jinv(2,3)*dh1dh7_param(2,i)+Jinv(3,3)*dh1dh7_param(3,i);
end
