function B=GetB_advec(pentaelem,gauss_coord)
%GETB_ADVEC - compute the B matrix for advection in thermal model
%
%   Compute B  matrix. B=[B1 B2 B3 B4 B5 B6] where Bi is of size numgrids*NDOF
%	 For grid i, Bi can be expressed in the basic coordinate system by :
%   Bi_basic=[Li]
%            [Li]
%            [Li]
%	 where h is the interpolation function for grid i.
%
%   Usage:
%      B=GetB_advec(pentaelem,gauss_coord)
%
%   See also GETB_CONDUCT, GETBPRIME_ADVEC, CREATEKMATRIX

num_grids=6;	

l1l6=GetNodalFunctions(pentaelem,gauss_coord);
    
%Build B:
B=zeros(3,num_grids);
    
for i=1:num_grids,
	B(1,i)=l1l6(i);
	B(2,i)=l1l6(i);
	B(3,i)=l1l6(i);
end
