function penpair = penpair(varargin)
%PENPAIR- constructor for penpair object
%
%   a penpair object is a penalty applied between several grids
%
%   Usage:
%      penpair = penpair(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	penpair.id=NaN;
	penpair.dof=NaN;
	penpair.grids=zeros(2,1);
	penpair.penalty_offset=NaN;
	
	penpair=class(penpair,'penpair');
case 1
	%If single argument of class penpair, we have a copy constructor. 
	if (isa(varargin{1},'penpair'))
		penpair = varargin{1};
	else
		error('penpair constructor error message: copy constructor called on a non ''penpair'' class object');
	end 
otherwise
	error('penpair constructor error message: 0 of 1 argument only in input.');
end
