function Ke=PenaltyCreateKMatrix(penpair,grids,materials,inputs,analysis_type,kmax)
%PENALTYCREATEKMATRIX - creates a penalty matrix for a particular grid
%
%   penpair is, as the name describes, a penalty load between two grids, for a certain degree of freedom.
%   This is the same as adding a infinitely stiff spring element between two grids, for a certain degree 
%   of freedom. The goal is to make the value of that dof identical on both grids. 
%   In order to do so, we add a stiffness matrix of the type [1 -1 ; -1 1]*lambda, where lambda is a penalty 
%
%   Usage:
%      Ke=PenaltyCreateKMatrix(penpair,grids,materials,inputs,analysis_type,kmax)
% 
%   See also CREATEPVECTOR, PENALTYCREATEPVECTOR, PENALTYCONTRAIN
 
%parameters
numgrids=2;

%initialize stiffness matrix
Ke=elemmatrix(2);

%Build linear indices for elementary stiffness matrix.
for i=1:numgrids,
	doflist=grids(penpair.grids(i)).grid.doflist; %list of dofs in the g-set
	dof=doflist(penpair.dof);
	Ke.row_indices(i)=dof;
end

Ke.terms(1,1)=kmax*10^penpair.penalty_offset;
Ke.terms(1,2)=-kmax*10^penpair.penalty_offset;
Ke.terms(2,1)=-kmax*10^penpair.penalty_offset;
Ke.terms(2,2)=kmax*10^penpair.penalty_offset;
