function pengrid = pengrid(varargin)
%PENGRID - constructor for pengrid object
%
%   a pengrid object is a penalty applied on a grid
%
%   Usage:
%      pengrid = pengrid(varargin)

switch nargin
case 0
	% if no input arguments, create a default object
	pengrid.id=NaN;
	pengrid.dof=NaN;
	pengrid.grid=NaN;
	pengrid.active=0;
	pengrid.penalty_offset=NaN;
	pengrid.thermal_steadystate=1;
	
	pengrid=class(pengrid,'pengrid');
case 1
	%If single argument of class pengrid, we have a copy constructor. 
	if (isa(varargin{1},'pengrid'))
		pengrid = varargin{1};
	else
		error('pengrid constructor error message: copy constructor called on a non ''pengrid'' class object');
	end 
otherwise
	error('pengrid constructor error message: 0 of 1 argument only in input.');
end
