%
%  display for the nonlinear_equality_constraint class.
%
%  []=display(nec)
%
function []=display(nec)

if ~isa(nec,'nonlinear_equality_constraint')
    error('Object ''%s'' is a ''%s'' class object, not ''%s''.',...
        inputname(1),class(nec),'nonlinear_equality_constraint');
end

%  display the object

disp(sprintf('\n'));
for i=1:numel(nec)
    disp(sprintf('class ''%s'' object ''%s%s'' = \n',...
        class(nec),inputname(1),string_dim(nec,i)));
    disp(sprintf('    descriptor: ''%s'''  ,nec(i).descriptor));
    disp(sprintf('        target: %g'      ,nec(i).target));
    disp(sprintf('    scale_type: ''%s'''  ,nec(i).scale_type));
    disp(sprintf('         scale: %g\n'    ,nec(i).scale));
end

end
