function globalvector = globalvector(varargin)
% globalvector: constructor for globalvector object
switch nargin
case 0
	% if no input arguments, create a default object
	globalvector.nrows=NaN;
	globalvector.vector=NaN;
	
	globalvector=class(globalvector,'globalvector');
case 1
	%If single argument we have a copy constructor. 
	argument = varargin{1};
	if isa(argument,'globalvector'),
		globalvector=argument;
	else 
		if isnumeric(varargin{1}),
			numdof=argument;
			globalvector.nrows=numdof;
			globalvector.vector=sparse(numdof,1,0);

			globalvector=class(globalvector,'globalvector');
		elseif isstruct(argument),
			globalvector=class(argument,'globalvector');
		else
			error('elemmmatrix constructor error message: invalid input argument');
		end
	end
otherwise
	error('globalvector constructor error message: 0 of 1 argument only in input.');
end
