/* \file Exceptions.cpp
 * \brief: implementation of the exceptions.
 */


#include "../shared.h"
#include "../../include/macros.h"

ErrorException::ErrorException(const string &what_function,const string &what_arg){

	what_str=what_arg;
	function_name=what_function;
}

ErrorException::~ErrorException() throw(){
}

const char* ErrorException::what() const throw(){
	return what_str.c_str();
}

void ErrorException::Report(){

	_printf_("%s%s%s",function_name.c_str()," error message: ",what());
	return;
}


