/*
 * parallel.h: 
 */

#ifndef PARALLEL_H_
#define PARALLEL_H_

#include "../objects/objects.h"

int GradJCompute(ParameterInputs* inputs,FemModel* femmodel);

void diagnostic_core_nonlinear(Vec* pug,Mat* pK_ff0,Mat* pK_fs0, ParameterInputs* inputs,FemModel fem);
int cielothermal_core(Vec** pt_g,ParameterInputs* inputs,FemModel* femmodel);

//int GradJOrth(WorkspaceParams* workspaceparams);

int GoldenSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*,ParameterInputs*),FemModel* femmodel);

int BrentSearch(double* psearch_scalar,double* pJ,double xa, double xb, double tolerance, int maxiter, double fit,double optscal,double (*f)(double*,double,double,FemModel*,ParameterInputs*),FemModel* femmodel);
	
double objectivefunctionC(double* search_vector,double fit,double optscal,FemModel*  femmodel,ParameterInputs* inputs);

int GradJSearch(double* search_vector,FemModel* femmodel,int step);
//int GradJCheck(WorkspaceParams* workspaceparams,int step,int status);

//int ParameterUpdate(double* search_vector,int step, WorkspaceParams* workspaceparams,BatchParams* batchparams);
void OutputDiagnostic(Vec u_g,Vec tpartition,char* filename,NodeSets* nodesets,char* analysis_type);
int OutputThermal(Vec* t_g,Vec* tpartition,char* filename,char* analysis_type);
//int OutputControl(WorkspaceParams* workspaceparams,BatchParams* batchparams,Vec* u_g,Vec* tpartition, char* filename,char* analysis_type);
void WriteLockFile(char* filename);

void CreateFemModel(FemModel* femmodel,ConstDataHandle MODEL,char* analysis_type);
//int BatchDebug(Mat* Kgg,Vec* pg,FemModel* femmodel,char* filename);

#endif
