
/*
	OutputThermal.c: output model results for thermal solution.
*/
#include "../../../config.h"

#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)

#include "../include/cielo.h"

#undef __FUNCT__ 
#define __FUNCT__ "OutputThermal"

#undef CLEANUP
#define CLEANUP OutputThermalLocalCleanup();

void OutputThermalLocalCleanup(void);
	
int OutputThermal(Vec* t_g,Vec* partition,char* filename,char* analysis_type){

	/* error handling: */
	int i;
	int		noerr=1;	
	
	/* output: */
	FILE* fid=NULL;

	/* standard output: */
	double* serial_partition=NULL;
	int     serial_partition_rows;
	int    analysis_size;

	double* serial_t_g=NULL;
	int     serial_t_g_rows;
	int     dummy=1;

	/*serialize outputs: */
	VecShift(partition,1.0); //matlab indexing
	VecGetSize(*partition,&serial_partition_rows);
	noerr=VecToMPISerial(&serial_partition,partition);TESTEXIT(noerr);

	VecGetSize(*t_g,&serial_t_g_rows);
	noerr=VecToMPISerial(&serial_t_g,t_g);TESTEXIT(noerr);

	/* Open output file to write raw binary data: */
	if(my_rank==0){
		fid=fopen(filename,"wb");
		if(fid==NULL){
			_printf_("%s%s%s%s\n",__FUNCT__," error message: could not open file ",filename," for binary writing.");
			noerr=0; goto cleanup_and_return;
		}

		/*Write solution type: */
		WriteDataToDisk(analysis_type,NULL,NULL,"String",fid);

		/*Write uset.gsize: */
		WriteDataToDisk(&uset->gsize,NULL,NULL,"Integer",fid);

		/*Write partition: */
		WriteDataToDisk(serial_partition,&serial_partition_rows,&dummy,"Mat",fid);
	
		/*Write solution to disk: */
		WriteDataToDisk(serial_t_g,&serial_t_g_rows,&dummy,"Mat",fid);
	
		/*Close file: */
		if(fclose(fid)!=0){
			_printf_("%s%s%s\n",__FUNCT__," error message: could not close file ",filename);
			noerr=0; goto cleanup_and_return;
		}
	}

	cleanup_and_return:
	TESTEXIT(noerr);

	EXIT(noerr);
}	
void OutputThermalLocalCleanup(void){
	return;
}
#endif //#if defined(_PARALLEL_) && defined(_HAVE_PETSC_)

