/*!\file Rgb.h
 * \brief: header file for rgb object
 */

#ifndef _RGB_H_
#define _RGB_H_

#include "./Object.h"
#include "../DataSet/DataSet.h"

class Rgb: public Object{

	private: 
		int	id; /*! id, to track it*/
		int	nodeid1; 
		int	nodeid2; 
		int dof; /*!component*/

	public:

		Rgb();
		Rgb(int rgb_id,int rgb_nodeid1,int rgb_nodeid2, int rgb_dof);
		~Rgb();

		void   Echo();
		void   Marshall(char** pmarshalled_dataset);
		int    MarshallSize();
		char*  GetName();
		void   Demarshall(char** pmarshalled_dataset);
		int    Enum();
		int    GetId(); 
		int    MyRank();

		/*non virtual: */
		int    GetNodeId1();
		int    GetNodeId2();
		int    GetDof();
		Object* copy();

};

#endif  /* _RGB_H_ */
