/*!\file Penpair.h
 * \brief: header file for penpair object */

#ifndef _PENPAIR_H_
#define _PENPAIR_H_

#include "./Load.h"
#include "./Node.h"
#include "./Element.h"

class Penpair: public Load{

	private: 

		int		id;
		double  penalty_offset; //penalty used
		int     penalty_lock;  //maximum counter can go until locks the penalty.
		int     numdofs; //switch from penalty pairing of 1 or 2 dofs.
		
		/*nodes: */
		int     node_ids[2];
		Node*   nodes[2];
		int     node_offsets[2];

		/*penalty pairing of one dof: */
		int     dof;

		/*penalty pairing of two dofs: */
		int      element_ids[2];//elements for those two grids
		Element* elements[2];
		int      element_offsets[2];

		double  friction; //friction coefficient
		int     fill; 
		double  normal[2];
		double  length;

	public:

		Penpair();
		Penpair(int	id, double penalty_offset,int  penalty_lock,int numdofs,int nodes_ids[2],int dof,int element_ids[2],double friction,int fill,double normal[2],double length);
		~Penpair();

		void  Echo();
		void  Marshall(char** pmarshalled_dataset);
		int   MarshallSize();
		char* GetName();
		void  Demarshall(char** pmarshalled_dataset);
		int   Enum();
		int   GetId(); 
		int   MyRank();
		void  DistributeNumDofs(int* numdofspernode,int analysis_type);
		void  Configure(void* elements,void* nodes,void* materials);
		void  CreateKMatrix(Mat Kgg,ParameterInputs* inputs,int analysis_type);
		void  CreatePVector(Vec pg, ParameterInputs* inputs, int analysis_type);
		void  UpdateFromInputs(ParameterInputs* inputs);
		void  PenaltyCreateKMatrix(Mat Kgg,ParameterInputs* inputs,double kmax,int analysis_type);
		void  PenaltyCreatePVector(Vec pg,ParameterInputs* inputs,double kmax,int analysis_type);
		Object* copy();
};

#endif  /* _PENPAIR_H_ */


