/*!\file:  ParameterInputs.h
 * \brief prototype for parameter inputs, from matlab workspace.
 */ 
#ifndef PARAMETER_INPUTS_H_
#define PARAMETER_INPUTS_H_

#include "../toolkits/toolkits.h"

struct ParameterInputs{

	int	nfields; //number of inputs
	char** field_names;  //characterization of each field.
	double** fields;  //value of each field.
	int* fields_length; //length of each values field

};

ParameterInputs* NewParameterInputs();
void             DeleteParameterInputs(ParameterInputs** pinputs);
int              ParameterInputsEcho(ParameterInputs* inputs,int longecho);
double*          ParameterInputsRecover(ParameterInputs* inputs,char* field_name);

int              ParameterInputsAddFromVec(ParameterInputs* inputs,Vec vector,char* field_name);
int              ParameterInputsAddFromMat(ParameterInputs* inputs,double* vector,int vector_size,char* field_name);
int              ParameterInputsAddFromDouble(ParameterInputs* inputs,double scalar, char* pfield_name);

#ifdef _SERIAL_
#include "mex.h"
void  ParameterInputsInit(ParameterInputs** pthis, const mxArray* inputhandle);
#endif

#endif
