/*!\file: NodeSet.cpp
 * \brief routines for handling node sets (m,n,f and s sets)
 */ 

#include "../include/macros.h"
#include "../shared/shared.h"
#include "./objects.h"

/*--------------------------------------------------
	Construtor
  --------------------------------------------------*/
NodeSets::NodeSets( double* nodesets_pv_m,double* nodesets_pv_n,double* nodesets_pv_f,double* nodesets_pv_s,
		int nodesets_gsize,int nodesets_msize,int nodesets_nsize,int nodesets_fsize,int nodesets_ssize){

	gsize=nodesets_gsize;
	msize=nodesets_msize;
	nsize=nodesets_nsize;
	fsize=nodesets_fsize;
	ssize=nodesets_ssize;

	pv_m=nodesets_pv_m;
	pv_n=nodesets_pv_n;
	pv_f=nodesets_pv_f;
	pv_s=nodesets_pv_s;

}



/*--------------------------------------------------
	Destructor:
  --------------------------------------------------*/

NodeSets::~NodeSets(void){

	xfree((void**)&pv_m);
	xfree((void**)&pv_n);
	xfree((void**)&pv_f);
	xfree((void**)&pv_s);

}

/*--------------------------------------------------
	Echo
  --------------------------------------------------*/

void NodeSets::Echo(void){
	
	int i;

	printf("\nNodeSets echo:\n");
	printf(" gsize: %i\n",gsize);
	printf(" msize: %i\n",msize);
	printf(" nsize: %i\n",nsize);
	printf(" fsize: %i\n",fsize);
	printf(" ssize: %i\n",ssize);

	if(pv_m){
		printf("m set:\n");
		for(i=0;i<msize;i++){
			printf("%g\n",pv_m[i]);
		}
	}
		
	if(pv_n){
		printf("n set:\n");
		for(i=0;i<nsize;i++){
			printf("%g\n",pv_n[i]);
		}
	}
	
	if(pv_f){
		printf("f set:\n");
		for(i=0;i<fsize;i++){
			printf("%g\n",pv_f[i]);
		}
	}
	
	if(pv_s){
		printf("s set:\n");
		for(i=0;i<ssize;i++){
			printf("%g\n",pv_s[i]);
		}
	}	
}


/*Access to internals: */
int NodeSets::GetGSize(){ return gsize;}
int NodeSets::GetMSize(){ return msize;}
int NodeSets::GetNSize(){ return nsize;}
int NodeSets::GetFSize(){ return fsize;}
int NodeSets::GetSSize(){ return ssize;}
double* NodeSets::GetPV_M(){ return pv_m;}
double* NodeSets::GetPV_N(){ return pv_n;}
double* NodeSets::GetPV_F(){ return pv_f;}
double* NodeSets::GetPV_S(){ return pv_s;}


