/*! \file Friction.h
 *  \brief Friction object, interface, declaration
 */

#ifndef _FRICTION_H
#define _FRICTION_H

/*!Friction declaration: */
struct Friction {

	char*   element_type;
	double  gravity;
	double  rho_ice;
	double  rho_water;
	double* K;
	double* bed;
	double* thickness;
	double* velocities;
	double  p;
	double  q;

};


/* creation, initialisation: */

	Friction*	NewFriction(void);
	int		    FrictionInit(Friction* friction);
	void        DeleteFriction(Friction** pfriction);
	void  FrictionGetAlpha2(double* alpha2, Friction* friction);
	void  FrictionGetAlphaComplement(double* alpha_complement, Friction* friction);

#endif  /* _FRICTION_H */

