#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#version of SuiteSparse
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/SuiteSparse-//g'`

#Some cleanup
rm -rf install SuiteSparse-$version

#Create install directories
mkdir install

#Untar 
tar -zxvf  SuiteSparse-$version.tar.gz

#Move SuiteSparse into install directory
mv SuiteSparse/* install
rm -rf SuiteSparse

#Apply patch 
cd install 
cp SuiteSparse_install.m SuiteSparse_install_ice.m
patch SuiteSparse_install_ice.m ../SuiteSparse_install.patch

#Symlink metis-4.0 to where it is.
ln -s ../../metis/install/   metis-4.0

#Now compile using matlab
matlab << EOF
SuiteSparse_install_ice
EOF
