#!/bin/bash

#Get number of cpus on current platform
NUMCPUS=`grep -c processor /proc/cpuinfo`;

#version of qhull
version=`echo *.tar.gz | sed 's/\.tar\.gz//g' | sed 's/qhull-//g'`

#Some cleanup
rm -rf src install qhull-$version

#Create src and install directories
mkdir src install

#Untar 
tar -zxvf  qhull-$version.tar.gz

#Move qhull to src directory
rm -rf src/*
mv qhull-$version/* src/
rm -rf qhull-$version

#Configure qhull
cd src

./configure --prefix="$ISSM_DIR/packages/qhull/install"

#Compile qhull
make  -j $NUMCPUS

#Install qhull
make  install
