#Server Makefile configuration.
   
ifeq ($(cluster),1)

	#Add some strict compiling 
	#CFLAGS  += -Werror-implicit-function-declaration

	#Undefine matlab if already defined. 
	CFLAGS+= -UMATLAB

	ifdef MPILAUNCH
		mpilaunch = $(MPILAUNCH)
	else
		mpilaunch= mpi
	endif

	ifeq ($(mpilaunch),bsub)
		CFLAGS   += -D_BSUB_
	endif
	ifeq ($(mpilaunch),mpi)
		CFLAGS   += -D_MPI_
	endif

	#MPIIO flags: 
	CFLAGS += -D_FILE_OFFSET_BITS=64 -D_LARGEFILE64_SOURCE=1 -D_LARGEFILE_SOURCE=1 -D_USE_LUSTRE_
	#CFLAGS += -D_FILE_OFFSET_BITS=64 

	#Server flags
	#CFLAGS += -fno-strict-aliasing -funroll-loops -g3 -D_SERVER_ -O3
	CFLAGS += -fno-strict-aliasing  -D_SERVER_ -O3
	#CFLAGS += -Wall

	#Cluster flags: 
	MPIROOT=/opt/mpich/gm/intel8.0
	CC=$(MPIROOT)/bin/mpicc

	CFLAGS +=  -D_CLUSTER_ -I$(MPIROOT)/include

	COMPUTLIBS += -L$(MPIROOT)/lib -lfmpich -lmpich  

	
	#SLEPC Definitions
	ifeq (slepc,$(findstring slepc,$(computlib)))
		SLEPCDIR=/scratch/larour/libraries_tier2_ice/slepc-2.3.3
		
		CFLAGS += -I$(SLEPCDIR)/include

		COMPUTLIBS += $(SLEPCDIR)/lib/$(PETSCARCH)/libslepc.a
		#COMPUTLIBS += -L$(SLEPCDIR)/lib/$(PETSCARCH) -lslepc
	endif

	
	#PLAPACK Definitions.
	ifeq (plapack,$(findstring plapack,$(computlib)))
		PLAPACKDIR=$(PETSCROOT)/externalpackages/PLAPACKR32
		#We need also Petsc Plapack prototypes found in  $PETSCROOT)/src/mat/impls/dense/mpi/plapack/PLA_prototypes.h

		CFLAGS += -I$(PLAPACKDIR)/INCLUDE -I$(PETSCROOT)/src/mat/impls/dense/mpi/plapack/

		COMPUTLIBS += -L$(PLAPACKDIR)/$(PETSCARCH) -lPLAPACK
	endif

	#MUMPS Definitions.
	ifeq (mumps,$(findstring mumps,$(computlib)))
		MUMPSDIR=$(PETSCROOT)/externalpackages/MUMPS_4.7.3/

		CFLAGS += -I$(MUMPSDIR)/include 

		COMPUTLIBS += -L$(MUMPSDIR)/$(PETSCARCH)/lib -ldmumps -lcmumps -lpord
	endif

	#PETSC Definitions: 
	ifeq (petsc,$(findstring petsc,$(computlib)))
		#LAPACK and BLAS definitions needed for MPI use of Petsc.
		#FBLASLAPACKDIR=$(PETSCROOT)/externalpackages/fblaslapack/$(PETSCARCH)
		#COMPUTLIBS += -L$(FBLASLAPACKDIR) -lflapack -lfblas 
		FBLASLAPACKDIR=/opt/intel/mkl/8.0/lib/32
		COMPUTLIBS += $(FBLASLAPACKDIR)/libmkl_lapack.a $(FBLASLAPACKDIR)/libmkl_ia32.a $(FBLASLAPACKDIR)/libmkl_def.so -L$(FBLASLAPACKDIR) -lguide -lpthread
		#COMPUTLIBS += -Wl,-rpath,$(FBLASLAPACKDIR) -L$(FBLASLAPACKDIR) -lmkl_lapack32 -lmkl_def -lguide -lpthread
	endif

	#SCALAPACK Definitions
	ifeq (scalapack,$(findstring scalapack,$(computlib)))
		#SCALAPACKDIR=/home/larour/SCALAPACK
		SCALAPACKDIR=$(PETSC_DIR)/externalpackages/SCALAPACK/linux-gnu
		#We need BLACS to work with Scalapack
		#BLACSDIR=/home/larour/BLACS/LIB
		BLACSDIR=$(PETSC_DIR)/externalpackages/blacs-dev/linux-gnu
	
		COMPUTLIBS += -L$(SCALAPACKDIR) -lscalapack 
		#COMPUTLIBS += $(BLACSDIR)/blacsF77init_MPI-LINUX-0.a $(BLACSDIR)/blacs_MPI-LINUX-0.a $(BLACSDIR)/blacsCinit_MPI-LINUX-0.a
		COMPUTLIBS += -L$(BLACSDIR) -lblacs 

	
	
	endif

	#Metis definitions
	METISDIR=/scratch/larour/libraries_tier2_ice/metis-4.0/
	CFLAGS += -I$(METISDIR)/Lib
	COMPUTLIBS += -L$(METISDIR) -lmetis

	#Super lu
	SUPERLUDIR=$(PETSC_DIR)/externalpackages/SuperLU_DIST_2.0-Jan_5_2006/$(PETSCARCH)/
	COMPUTLIBS += -L$(SUPERLUDIR) -lsuperlu_dist_2.0

	#Spooles
	
	SPOOLESDIR=$(PETSC_DIR)/externalpackages/spooles-2.2/$(PETSCARCH)
	COMPUTLIBS += -L$(SPOOLESDIR) -lspooles
	SPOOLESDIR2=$(PETSC_DIR)/externalpackages/spooles-2.2/$(PETSCARCH)/MPI/src
	COMPUTLIBS += -L$(SPOOLESDIR2) -lspoolesMPI


	#Extra definitions
	#G2CDIR=/lib/ssa/gcc-lib/i386-redhat-linux-gnu/3.5-tree-ssa
	#G2CDIR=/usr/lib/gcc-lib/i386-redhat-linux/3.2.2/
	FORTRANDIR=/opt/intel/compilers/ifort_8.0.046/lib 

	#COMPUTLIBS += -lnsl -lrt -L/usr/X11R6/lib -lX11 -L$(G2CDIR) -lg2c -L$(FORTRANDIR) -lifcore  -lpetsc
	COMPUTLIBS += -lnsl -lrt -L/usr/X11R6/lib -lX11 -L$(FORTRANDIR) -lifcore  -lpetsc  $(MPIROOT)/lib/libmpich.a
	
endif 

ifeq ($(batch),1)
#Add _BATCH_ flag to compilation
CFLAGS+= -D_BATCH_
endif
