#!/bin/bash

#Go to root directory, because doxygen seems to have a problem running otherwise.
cd $ISSM_DIR

#Symlink the doxygen configuration file to root dir.
ln -s "$ISSM_DIR/doc/developerguide/doxygen.config" ./doxygen.config

#Run doxygen
doxygen doxygen.config

#Erase symlink
rm doxygen.config

#change index and put it in doc
cd $ISSM_DIR/doc/
cat developerguide/chtml/index.html  | sed -e "s/tabs.css/developerguide\/chtml\/tabs.css/g" | sed -e "s/doxygen.css/developerguide\/chtml\/doxygen.css/g" | sed -e "s/href=\"index.html/href=\"developerguide\/chtml\/index.html/g" | sed -e "s/annotated.html/developerguide\/chtml\/annotated.html/g" | sed -e "s/files.html/developerguide\/chtml\/files.html/g" > index.html
