/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*
 *  (C) 2001 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 */

#include "rdma_impl.h"
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

/*#undef USE_IOV_LEN_2_SHORTCUT*/
#define USE_IOV_LEN_2_SHORTCUT

#undef FUNCNAME
#define FUNCNAME MPIDI_CH3I_RDMA_put_datav
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPIDI_CH3I_RDMA_put_datav(MPIDI_VC_t *vc, MPID_IOV *iov, int iovlen, int *num_bytes_ptr)
{
    int i;
    unsigned int total = 0;
    unsigned int num_bytes;
    unsigned int cur_avail, dest_avail;
    unsigned char *cur_pos, *dest_pos;
    int index;
    MPIDI_STATE_DECL(MPID_STATE_MPIDI_CH3I_RDMA_PUT_DATAV);
    MPIDI_STATE_DECL(MPID_STATE_MEMCPY);

    MPIDI_FUNC_ENTER(MPID_STATE_MPIDI_CH3I_RDMA_PUT_DATAV);

    MPIDI_DBG_PRINTF((60, FCNAME, "entering"));
    index = vc->shm.write_shmq->tail_index;
    if (vc->shm.write_shmq->packet[index].avail == MPIDI_CH3I_PKT_FILLED)
    {
	*num_bytes_ptr = 0;
	MPIDI_DBG_PRINTF((60, FCNAME, "exiting"));
	MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_PUT_DATAV);
	return MPI_SUCCESS;
    }

    MPIU_DBG_PRINTF(("writing to write_shmq %p\n", vc->shm.write_shmq));
#ifdef USE_IOV_LEN_2_SHORTCUT
    if (iovlen == 2 && (iov[0].MPID_IOV_LEN + iov[1].MPID_IOV_LEN) < MPIDI_CH3I_PACKET_SIZE)
    {
	MPIDI_DBG_PRINTF((60, FCNAME, "writing %d bytes to write_shmq %08p packet[%d]", iov[0].MPID_IOV_LEN + iov[1].MPID_IOV_LEN, vc->shm.write_shmq, index));
	MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
	memcpy(vc->shm.write_shmq->packet[index].data, 
	       iov[0].MPID_IOV_BUF, iov[0].MPID_IOV_LEN);
	MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
	MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
	memcpy(&vc->shm.write_shmq->packet[index].data[iov[0].MPID_IOV_LEN],
	       iov[1].MPID_IOV_BUF, iov[1].MPID_IOV_LEN);
	MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
	vc->shm.write_shmq->packet[index].num_bytes = 
	    iov[0].MPID_IOV_LEN + iov[1].MPID_IOV_LEN;
	total = vc->shm.write_shmq->packet[index].num_bytes;
	MPID_WRITE_BARRIER();
	vc->shm.write_shmq->packet[index].avail = MPIDI_CH3I_PKT_FILLED;
	vc->shm.write_shmq->tail_index =
	    (vc->shm.write_shmq->tail_index + 1) % MPIDI_CH3I_NUM_PACKETS;
	MPIDI_DBG_PRINTF((60, FCNAME, "write_shmq tail = %d", vc->shm.write_shmq->tail_index));
	*num_bytes_ptr = total;
	MPIDI_DBG_PRINTF((60, FCNAME, "exiting"));
	MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_PUT_DATAV);
	return MPI_SUCCESS;
    }
#endif

    dest_pos = vc->shm.write_shmq->packet[index].data;
    dest_avail = MPIDI_CH3I_PACKET_SIZE;
    vc->shm.write_shmq->packet[index].num_bytes = 0;
    for (i=0; i<iovlen; i++)
    {
	if (iov[i].MPID_IOV_LEN <= dest_avail)
	{
	    total += iov[i].MPID_IOV_LEN;
	    vc->shm.write_shmq->packet[index].num_bytes += iov[i].MPID_IOV_LEN;
	    dest_avail -= iov[i].MPID_IOV_LEN;
	    MPIDI_DBG_PRINTF((60, FCNAME, "writing %d bytes to write_shmq %08p packet[%d]", iov[i].MPID_IOV_LEN, vc->shm.write_shmq, index));
	    MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
	    memcpy(dest_pos, iov[i].MPID_IOV_BUF, iov[i].MPID_IOV_LEN);
	    MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
	    dest_pos += iov[i].MPID_IOV_LEN;
	}
	else
	{
	    total += dest_avail;
	    vc->shm.write_shmq->packet[index].num_bytes = MPIDI_CH3I_PACKET_SIZE;
	    MPIDI_DBG_PRINTF((60, FCNAME, "writing %d bytes to write_shmq %08p packet[%d]", dest_avail, vc->shm.write_shmq, index));
	    MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
	    memcpy(dest_pos, iov[i].MPID_IOV_BUF, dest_avail);
	    MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
	    MPID_WRITE_BARRIER();
	    vc->shm.write_shmq->packet[index].avail = MPIDI_CH3I_PKT_FILLED;
	    cur_pos = iov[i].MPID_IOV_BUF + dest_avail;
	    cur_avail = iov[i].MPID_IOV_LEN - dest_avail;
	    while (cur_avail)
	    {
		index = vc->shm.write_shmq->tail_index = 
		    (vc->shm.write_shmq->tail_index + 1) % MPIDI_CH3I_NUM_PACKETS;
		MPIDI_DBG_PRINTF((60, FCNAME, "write_shmq tail = %d", vc->shm.write_shmq->tail_index));
		if (vc->shm.write_shmq->packet[index].avail == MPIDI_CH3I_PKT_FILLED)
		{
		    *num_bytes_ptr = total;
		    MPIDI_DBG_PRINTF((60, FCNAME, "exiting"));
		    MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_PUT_DATAV);
		    return MPI_SUCCESS;
		}
		num_bytes = MPIDU_MIN(cur_avail, MPIDI_CH3I_PACKET_SIZE);
		vc->shm.write_shmq->packet[index].num_bytes = num_bytes;
		MPIDI_DBG_PRINTF((60, FCNAME, "writing %d bytes to write_shmq %08p packet[%d]", num_bytes, vc->shm.write_shmq, index));
		MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
		memcpy(vc->shm.write_shmq->packet[index].data, cur_pos, num_bytes);
		MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
		total += num_bytes;
		cur_pos += num_bytes;
		cur_avail -= num_bytes;
		if (cur_avail)
		{
		    MPID_WRITE_BARRIER();
		    vc->shm.write_shmq->packet[index].avail = MPIDI_CH3I_PKT_FILLED;
		}
	    }
	    dest_pos = vc->shm.write_shmq->packet[index].data + num_bytes;
	    dest_avail = MPIDI_CH3I_PACKET_SIZE - num_bytes;
	}
	if (dest_avail == 0)
	{
	    MPID_WRITE_BARRIER();
	    vc->shm.write_shmq->packet[index].avail = MPIDI_CH3I_PKT_FILLED;
	    index = vc->shm.write_shmq->tail_index = 
		(vc->shm.write_shmq->tail_index + 1) % MPIDI_CH3I_NUM_PACKETS;
	    if (vc->shm.write_shmq->packet[index].avail == MPIDI_CH3I_PKT_FILLED)
	    {
		*num_bytes_ptr = total;
		MPIDI_DBG_PRINTF((60, FCNAME, "exiting"));
		MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_PUT_DATAV);
		return MPI_SUCCESS;
	    }
	    dest_pos = vc->shm.write_shmq->packet[index].data;
	    dest_avail = MPIDI_CH3I_PACKET_SIZE;
	    vc->shm.write_shmq->packet[index].num_bytes = 0;
	}
    }
    if (dest_avail < MPIDI_CH3I_PACKET_SIZE)
    {
	MPID_WRITE_BARRIER();
	vc->shm.write_shmq->packet[index].avail = MPIDI_CH3I_PKT_FILLED;
	vc->shm.write_shmq->tail_index = 
	    (vc->shm.write_shmq->tail_index + 1) % MPIDI_CH3I_NUM_PACKETS;
	MPIDI_DBG_PRINTF((60, FCNAME, "write_shmq tail = %d", vc->shm.write_shmq->tail_index));
    }

    *num_bytes_ptr = total;
    MPIDI_DBG_PRINTF((60, FCNAME, "exiting"));
    MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_PUT_DATAV);
    return MPI_SUCCESS;
}

#undef FUNCNAME
#define FUNCNAME MPIDI_CH3I_RDMA_read_datav
#undef FCNAME
#define FCNAME MPIDI_QUOTE(FUNCNAME)
int MPIDI_CH3I_RDMA_read_datav(MPIDI_VC_t *recv_vc_ptr, MPID_IOV *iov, int iovlen, int *num_bytes_ptr)
{
    int error;
    void *mem_ptr;
    char *iter_ptr;
    int num_bytes;
    MPIDI_CH3I_SHM_Packet_t *pkt_ptr;
    MPIDI_CH3I_SHM_Queue_t *shm_ptr;
    register int index, iov_index = 0, total = 0;
    MPIDI_STATE_DECL(MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV);
    MPIDI_STATE_DECL(MPID_STATE_MEMCPY);

    MPIDI_FUNC_ENTER(MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV);

    shm_ptr = recv_vc_ptr->shm.read_shmq;
    if (shm_ptr == NULL)
    {
	error = MPIR_Err_create_code(MPI_SUCCESS, MPIR_ERR_FATAL, FCNAME, __LINE__, MPI_ERR_OTHER, "**arg", 0);
	MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV);
	return error;
    }
    index = shm_ptr->head_index;
    pkt_ptr = &shm_ptr->packet[index];

    /* if the packet at the head index is available, the queue is empty */
    if (pkt_ptr->avail == MPIDI_CH3I_PKT_EMPTY)
    {
	*num_bytes_ptr = 0;
	MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV);
	return MPI_SUCCESS;
    }
    MPID_READ_BARRIER(); /* no loads after this line can occur before the avail flag has been read */

    MPIU_DBG_PRINTF(("MPIDI_CH3I_SHM_read_progress: reading from queue %p\n", shm_ptr));

    mem_ptr = (void*)(pkt_ptr->data + pkt_ptr->offset);
    num_bytes = pkt_ptr->num_bytes;

    iter_ptr = mem_ptr;
    while (num_bytes && iovlen > 0)
    {
	if ((int)iov[iov_index].MPID_IOV_LEN <= num_bytes)
	{
	    /* copy the received data */
	    MPIDI_DBG_PRINTF((60, FCNAME, "reading %d bytes from read_shmq %08p packet[%d]", iov[iov_index].MPID_IOV_LEN, shm_ptr, index));
	    MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
	    memcpy(iov[iov_index].MPID_IOV_BUF, iter_ptr,
		iov[iov_index].MPID_IOV_LEN);
	    MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
	    iter_ptr += iov[iov_index].MPID_IOV_LEN;
	    num_bytes -= iov[iov_index].MPID_IOV_LEN;
	    iov_index++;
	    iovlen--;
	}
	else
	{
	    /* copy the received data */
	    MPIDI_DBG_PRINTF((60, FCNAME, "reading %d bytes from read_shmq %08p packet[%d]", num_bytes, shm_ptr, index));
	    MPIDI_FUNC_ENTER(MPID_STATE_MEMCPY);
	    memcpy(iov[iov_index].MPID_IOV_BUF, iter_ptr, num_bytes);
	    MPIDI_FUNC_EXIT(MPID_STATE_MEMCPY);
	    iter_ptr += num_bytes;
	    num_bytes = 0;
	}
    }
    total += (unsigned int)((unsigned char*)iter_ptr - (unsigned char*)mem_ptr);
    if (num_bytes == 0)
    {
	/* put the shmem buffer back in the queue */
	pkt_ptr->offset = 0;
	MPID_READ_WRITE_BARRIER(); /* the writing of the flag cannot occur before the reading of the last piece of data */
	pkt_ptr->avail = MPIDI_CH3I_PKT_EMPTY;
	MPIU_Assert(&shm_ptr->packet[index] == pkt_ptr);
	shm_ptr->head_index = (index + 1) % MPIDI_CH3I_NUM_PACKETS;
	MPIDI_DBG_PRINTF((60, FCNAME, "read_shmq head = %d", shm_ptr->head_index));
    }
    else
    {
	/* update the head of the shmem queue */
	pkt_ptr->offset += (pkt_ptr->num_bytes - num_bytes);
	pkt_ptr->num_bytes = num_bytes;
    }

    *num_bytes_ptr = total;
    MPIDI_FUNC_EXIT(MPID_STATE_MPIDI_CH3I_RDMA_READ_DATAV);
    return MPI_SUCCESS;
}
