% This file can be run to update the velocity archives  of the test11.
% This test deals with an iceshelf with icefront for a 3d model. The geometry 
% is square. Just run this file in Matlab, with a properly setup Ice code. 

% The archive files will be saved in this directory but will not commited to ice1. 
% Just commit the result if you want to.

md=model;
md=mesh(md,'DomainOutline.exp',100000);
md=geography(md,'all','');
md=parameterize(md,'Square.par');
md=extrude(md,10,3);
md=setelementstype(md,'pattyn','Pattyn.exp','fill','macayeal','stokes','Stokes.exp');

%Compute solution with Ice model
md=solve(md,'diagnostic','ice');
archive_velocity=md.vel;

%Save the solution in the directory
save archive_velocity  archive_velocity 

%Compute solution with Ice model
md=solve(md,'thermalsteady','ice');
archive_temperature=md.temperature;
archive_melting=md.melting;

%Save the solution in the directory
save archive_temperature archive_temperature
save archive_melting archive_melting
