/*\file ParamsToWorkspace.c
 *\brief: output parameters to params structure in matlab workspace
 */

#include "./ParamsToWorkspace.h"

void mexFunction( int nlhs, mxArray* plhs[], int nrhs, const mxArray* prhs[]){

	/*diverse: */
	int   noerr=1;

	/*input datasets: */
	DataSet* parameters=NULL;

	/* output datasets: */

	/*Boot module: */
	MODULEBOOT();

	/*checks on arguments on the matlab side: */
	CheckNumMatlabArguments(nlhs,NLHS,nrhs,NRHS,__FUNCT__,&ParamsToWorkspaceUsage);

	/*Input datasets: */
	FetchData((void**)&parameters,NULL,NULL,PARAMETERSIN,"DataSet",NULL);

	/*Write parameters into a matlab structure in the matlab workspace: */
	WriteParams(PARAMETERSOUT,parameters);

	/*Free ressources: */
	delete parameters;

	/*end module: */
	MODULEEND();
}

void ParamsToWorkspaceUsage(void)
{
	_printf_("\n");
	_printf_("   usage: [m.params] = %s(parameters);\n",__FUNCT__);
	_printf_("\n");
}
